<?php

global $debug;

$debug = 999;

require_once('tilib.php');
require_once('lib/nusoap.php');

$pathback = getPathBack();

echo("<pre>\r\n");
echo("Path = ".$pathback."<br>");

$serverpath = str_replace("TestLaunch.php", "DoLaunchRequest.php", getPathBack());

$outcomepath = str_replace("TestLaunch.php", "DoOutcomeRequest.php", getPathBack());

echo("Launch Request Path=".$serverpath."<br>");
echo("Outcome Request Path=".$outcomepath."<br>");

// Set up the data structures

$LaunchRequestData = 
array ( 
'Parameters' => array ( 
  'CoreSettings' => array (
    "ProxyTool" => array(
      "ProxyToolName" => "Proxy Test from LaunchTest.php",
      "ProxyToolVersion" => array(
        "major" => "1",
        "minor" => "0"
         ) ,
      "IMSTIVersion" => array(
        "major" => "1",
        "minor" => "0"
         ) ,
      "ProxyToolDescription" => "This is a simple hardcoded PHP script that puts the parameters into WSDL and makes the call."
       ) ,
    "TIR" => array (
      "LaunchService" => array(
        "ServiceName" => "DoLaunchRequest.php is our end point for this - PHP is talking to PHP and exchanging hard coded messages.",
        "ServiceLocation" => $serverpath,
        "ServiceProfileName" => "SimpleOutcomeProfile"
        ) ,
      "OutcomeService" => array(
        "ServiceName" => "SakaiOutcomeService",
        "ServiceLocation" => $outcomepath,
        "ServiceProfileName" => "SimpleOutcomeProfile"
        )
      )
   ),
   'ContextualSettings' => array ( 
      'LaunchProfile' => array ( 
        "LaunchIdentifier" => 'IDENTIFIER123456',
        "Role" => 'Student',
        "LaunchType" => 'Fun Launch Type'
        )
    ),
    'ToolSettings' => array (
      'Ancillary' => 'A bunch of Ancillary stuff - clearly not the main stuff - who cares it is all hard coded anyways :)'
    )
  )
);

// var_dump($LaunchRequestData);

// $client = new soapclient($serverpath);
$client = new soapclient("TIRLaunchSyncSingle.wsdl", true);
$client->setEndpoint($serverpath);

echo("</pre>\r\n");

$err = $client->getError();
if ($err) {
	echo '<h2>Constructor error</h2><pre>' . $err . '</pre>';
}

echo "<h2>Calling Web Service...</h2>\r\n";
$result = $client->call('ProxyToolLaunch', $LaunchRequestData);
// $result = $client->call('ProxyToolLaunch', array('Dude' => 'Abides') , "A", "B");

echo "<h2>Web Service Request Completed</h2>\r\n";

if ($client->fault) {
	echo '<h2>Fault (This is expected)</h2><pre>'; print_r($result); echo '</pre>';
} else {
	$err = $client->getError();
	if ($err) {
		echo '<h2>Error</h2><pre>' . $err . '</pre>';
	} else {
$toolpath = $result['ProxyToolLaunchResponse']['LaunchDirective']['PerformRedirectAction'];
if ( isset($toolpath) ) {
echo "<a href=$toolpath target=_new>Launch the tool</a> ($toolpath)";
}
		echo '<h2>Result</h2><pre>'; print_r($result); echo '</pre>';
	}
}

echo "The remainder of this is extensive debug and logging...<br>\r\n";

echo '<h2>Array before Serialization</h2><pre>';
var_dump($LaunchRequestData);
echo '</pre>';

echo '<h2>Request</h2><pre>' . htmlspecialchars($client->request, ENT_QUOTES) . '</pre>';

echo '<h2>Response</h2><pre>' . htmlspecialchars($client->response, ENT_QUOTES) . '</pre>';

echo '<h2>Debug</h2><pre>' . htmlspecialchars($client->debug_str, ENT_QUOTES) . '</pre>';
?>
