<?php

global $debug;

$debug = 999;

require_once('tilib.php');
require_once('lib/nusoap.php');

$pathback = getPathBack();

echo("<pre>\r\n");
echo("Path = ".$pathback."<br>");

$serverpath = str_replace("TestEndpoint.php", "EndPointLaunch.php", getPathBack());

$outcomepath = str_replace("TestEndpoint.php", "DoOutcomeRequest.php", getPathBack());

echo("Launch Request Path=".$serverpath."<br>");
echo("Outcome Request Path=".$outcomepath."<br>");

// Set up the data structures

$ImsHeader = array(
  "imsx_version" => "IMSVERSION1",
  "imsx_messageIdentifier" => "918f18b8-8317-4a36-80c5-22672e4965b1",
  "SecurityProfile" => array(
    "MAC" =>  "59G8Pf1mNJyygMIAAUxNIw=="
  )
);

$Parameters = array(
  "CoreSettings" => array(
    "ProxyTool" => array(
      "ProxyToolName" => "Loop Back Endpoint",
      "ProxyToolVersion" => array(
        "major" => "1",
        "minor" => "0"
      ),
      "IMSTIVersion" => array(
        "major" =>  "1",
        "minor" =>  "0"
      ),
      "ProxyToolDescription" => "DO A LOOP"
    ),
    "TIR" => array(
      "LaunchService" => array(
        "ServiceName" => "sakai-target-tool launch service",
        "ServiceLocation" => "http://localhost/~csev/imsti-test/EndPointLaunch.php",
        "ServiceProfileName" => "SimpleOutcomeProfile"
      ),
      "OutcomeService" => array(
        "ServiceName" => "SakaiOutcomeService",
        "ServiceLocation" => "http://localhost:8080/sakai-imsti-tool/services/TIROutcomeServiceSyncSoapPort",
        "ServiceProfileName" => "SimpleOutcomeProfile"
      )
    )
  ), 
  "ContextualSettings" => array(
    "LaunchProfile" => array(
      "LaunchIdentifier" => "cb0de04b-e3f0-4237-0043-e9497ae4b199",
      "Role" => "admin",
      "LaunchType" =>  "test"
    ),
    "DeliveryContextProfile" => array(
      "IMSSourcedid" => array(
        "SourceName" => "sakaiContext",
        "SourceID" =>  "7e0e4999-6de7-4534-80d0-28196a675af5",
      ),
      "Name" => "User Entered Name",
      "ContextDescription" => "",
      "Ancillary" => "Ancillary material"
    ),
    "AcclipProfile" => array(
      "Ancillary" =>  ""
    ),
    "UserProfile" => array(
      "IMSSourcedid" => array(
        "SourceName" => "eid",
        "SourceID" => "csev"
      ),
      "Userid" => "6f525ab9-b7e5-47d6-003f-24f435585bb6",
      "FirstName" => "Charles",
      "LastName" => "Severance",
      "Ancillary" =>  "Ancillary material about a person"
    )
  ),
  "ToolSettings" => array(
    "Ancillary" => "Ancillary Tool Settings"
  )
);

// var_dump($LaunchRequestData);

$client = new soapclient($serverpath);
// $client = new soapclient("TIRLaunchSyncSingle.wsdl", true);
// $client->setEndpoint($serverpath);

echo("</pre>\r\n");

$err = $client->getError();
if ($err) {
	echo '<h2>Constructor error</h2><pre>' . $err . '</pre>';
}

$result = $client->call('ProxyToolLaunch', $ImsHeader, $Parameters);

if ($client->fault) {
	echo '<h2>Fault (This is expected)</h2><pre>'; print_r($result); echo '</pre>';
} else {
	$err = $client->getError();
	if ($err) {
		echo '<h2>Error</h2><pre>' . $err . '</pre>';
	} else {
        	$toolpath = $result['ProxyToolLaunchResponse']['LaunchDirective']['PerformRedirectAction'];
		if ( isset($toolpath) ) {
			echo "<a href=$toolpath target=_new>Launch the tool</a> ($toolpath)";
		}
	}
}

echo "The remainder of this is extensive debug and logging...<br>\r\n";

echo '<h2>Array before Serialization</h2><pre>';
var_dump($LaunchRequestData);
echo '</pre>';

echo '<h2>Request</h2><pre>' . htmlspecialchars($client->request, ENT_QUOTES) . '</pre>';

echo '<h2>Response</h2><pre>' . htmlspecialchars($client->response, ENT_QUOTES) . '</pre>';

echo '<h2>Debug</h2><pre>' . htmlspecialchars($client->debug_str, ENT_QUOTES) . '</pre>';
?>
