<?php

global $debug;

$debug = 999;

require_once('tilib.php');
require_once('lib/nusoap.php');

$pathback = getPathBack();

echo("<pre>\r\n");
echo("Path = ".$pathback."<br>");

$outcomepath = str_replace("TestOutcome.php", "DoOutcomeRequest.php", getPathBack());

echo("Outcome Request Path=".$outcomepath."<br>");

// Set up the data structures

$soap_message = array ( 
  "Parameters" => array (
    // 'OutcomeMessageRequest' => array (
      'OutcomeProfile' => array (  // A MinimalOutComeProfile
          "SOAP:Implementation" => "MinimalOutcomeProfile.Type",
          'MinimalOutcomeProfile.Type' => array (  // A MinimalOutComeProfile
    	    'Grade' => '42',
            'LaunchProfile' => array (
             'LaunchIdentifier' => 'LID',
             'Role' => 'Student',
             'LaunchType' >= 'LTY'
            ) 
         )
       )
     // )
  ),
  "HeaderInfoParameters" => array (
     'imsx_version' => '1.0',
     'imsx_messageIdentifier' => 'MID',
     'SecurityProfile' => array (
         "SOAP:Implementation" => "SharedSecretSecurityProfile.Type",
         'SharedSecretSecurityProfile.Type' => array (  // A MinimalOutComeProfile
             "MAC" => "00:ff:ff:ff:00:00"
         )
      )
  )
);


$client = new soapclient("TIROutcomeSyncSingle.wsdl", true);
$client->setEndpoint($outcomepath);

// $client = new soapclient($outcomepath);

echo("</pre>\r\n");

$err = $client->getError();
if ($err) {
	echo '<h2>Constructor error</h2><pre>' . $err . '</pre>';
}

echo "<h2>Calling Web Service...</h2>\r\n";
// $result = $client->call('OutcomeMessage', $OutcomeMessageRequest, $imsx_syncRequestHeaderInfo);
$result = $client->call('OutcomeMessage', $soap_message);

// $result = $client->call('OutcomeMessage', array('Dude' => 'Abides') , array("Grade" => "A") , array("Sakai" => "Was here") );

echo "<h2>Web Service Request Completed</h2>\r\n";

if ($client->fault) {
	echo '<h2>Fault (This is expected)</h2><pre>'; print_r($result); echo '</pre>';
} else {
	$err = $client->getError();
	if ($err) {
		echo '<h2>Error</h2><pre>' . $err . '</pre>';
	} else {
		echo '<h2>Result</h2><pre>'; print_r($result); echo '</pre>';
	}
}

echo "The remainder of this is extensive debug and logging...<br>\r\n";

echo '<h2>Array before Serialization</h2><pre>';
var_dump($soap_message);
echo '</pre>';

echo '<h2>Request</h2><pre>' . htmlspecialchars($client->request, ENT_QUOTES) . '</pre>';

echo '<h2>Response</h2><pre>' . htmlspecialchars($client->response, ENT_QUOTES) . '</pre>';

echo '<h2>Debug</h2><pre>' . htmlspecialchars($client->debug_str, ENT_QUOTES) . '</pre>';
?>
