clc
Vspan = [0 100]; % Range for the volume of the reactor 
y0 = [0]; % Initial values for the dependent variables i.e. X
[v,y]=ode45(@ODEfun,Vspan,y0);
R = 1.987;
dH = -14000;
To = 480;
Ke2 = 75000;
T2 = 298;
z=size(y);
for i=1:z(1,1)
T(i,1) = To-dH*y(i,1)/(75);
Ke(i,1) = Ke2*exp((dH/R)*((1/T2)-(1/T(i,1))));
Xe(i,1) = Ke(i)/(1+Ke(i,1));
end
plot(v,y(:,1),v,Xe)
legend('X','Xe')
xlabel('V')
ylabel('X')
title('Conversion profile down the reactor')
