clc
Vspan = [0 100]; % Range for the volume of the reactor 
y0 = [0]; % Initial values for the dependent variables i.e. X
[v,y]=ode45(@ODEfun,Vspan,y0);
dH = -14000;
To = 480;
z=size(y);
for i=1:z(1,1)
T(i,1) = To-dH*y(i,1)/(75);
end
plot(v,T)
legend('T')
xlabel('V')
ylabel('T (K)')
title('Temperature profile down the reactor')
