% Use of ARSST
clc
tspan = [0 20]; % Range for the time of the reaction 
y0 = [6.73;293]; % Initial values for the dependent variables
[t y]=ode45(@ODEfun,tspan,y0);
q=size(y);
CBo = 20.2;
V = .01;
SUMNA0THEiCpi =28;
dHrx =  -45650;
A =  3.734*10^7;
E =  15400;
R =  1.987;
for i=1:q
ra(i,1) = -A*exp(-E/R/y(i,2))*y(i,1)*CBo;
Tsdot(i,1) =  (-dHrx)*(-ra(i,1)*V)/SUMNA0THEiCpi;
end
plot(y(:,2),Tsdot(:,1));
 xlabel('Temp(K)')
 ylabel('Heating rate(K/min)')
