function dYfuncvecdt = ODEfun(t,Yfuncvec); 
Ca= Yfuncvec(1);
Cb= Yfuncvec(2);
Cc= Yfuncvec(3);
Cm= Yfuncvec(4);
T=Yfuncvec(5);
% Explicit equations
tau=0.06;
UA =55000;
Ta=85;
Fa0 = 300;
T0 =  68;
k =  16.96*10^12*exp(-32400/1.987/(T+460));
Fb0 =  2000;
Fm0 =  20;  
Fc0=0;
ra =  -k*Ca;
rb =  -k*Ca;
rc =  k*Ca;
ThetaCp =35+Fb0/Fa0*18+Fm0/Fa0*19.5;
v01 =  Fa0*58.08/(0.859/454*2.54^3*12^3)+Fb0*18.02/(0.9941/454*2.54^3*12^3)+Fc0*76.11/(1.036/454*2.54^3*12^3);
Ca0 =  Fa0/v01;
Cb0 =  Fb0/v01;
Cm0 =  Fm0/v01;
Cc0 =  Fc0/v01;
V=tau*v01;
X=(Ca0-Ca)/Ca0;
Nm =  Cm*V;
Na =  Ca*V;
Nb =  Cb*V;
Nc =  Cc*V;
NCp =  Na*35+Nb*18+Nc*46+Nm*19.5;

% Differential equations
dCadt =  1/tau*(Ca0-Ca)+ra;  
dCbdt =  1/tau*(Cb0-Cb)+rb;  
dCcdt =  1/tau*(0-Cc)+rc;  
dCmdt =  1/tau*(Cm0-Cm);  
dTdt =  (UA*(Ta-T)-Fa0*ThetaCp*(T-T0)+(-36000)*ra*V)/NCp;
dYfuncvecdt=[dCadt;dCbdt;dCcdt;dCmdt;dTdt];


