%PRS Example Falling Off the Steady State
clc
tspan = [0 4]; % Range for the time of the reaction 
y0 = [0.0445246;1.89346;0.281759;0.0217522;171.93]; % Initial values for the dependent variables. 
[t y]=ode45(@ODEfun,tspan,y0);
Fa0 = 300;
Fb0 =  2000;
Fc0=0;
v01 =  Fa0*58.08/(0.859/454*2.54^3*12^3)+Fb0*18.02/(0.9941/454*2.54^3*12^3)+Fc0*76.11/(1.036/454*2.54^3*12^3);
Ca0 =  Fa0/v01;
q=size(y);
for i=1:q
    X(i,1)=(Ca0-y(i,1))/Ca0;
end
plot(y(:,5),X(:,1));
axis([80 190 0 1])
xlabel('Temp(F)')
ylabel('X')
 

