%PRS Example CD13-2 Integral Control of a CSTR
clc
tspan = [0 4]; % Range for the time of the reaction 
y0 = [0.03789;2.12;0.143;0.2265;138.53;0]; 
[t y]=ode45(@ODEfun,tspan,y0);
q=size(y);
Fa0 = 80;
Fb0 = 1000;
Fm0 = 100;
v0 = Fa0/0.923+Fb0/3.45+Fm0/1.54;
Ca0 = Fa0/v0;
for i=1:q
X(i,1) = (Ca0-y(i,1))/Ca0;
end
plot(y(:,5),X(:,1));
xlabel('Temperature(F)')
ylabel('Conversion')
 legend('Conversion temperature phase trajectory')
