function dYfuncvecdt = ODEfun(t,Yfuncvec); 
Ca= Yfuncvec(1);
Cb= Yfuncvec(2);
Cc= Yfuncvec(3);
Cm= Yfuncvec(4);
T=Yfuncvec(5);
I=Yfuncvec(6);
% Explicit equations
Fa0 = 80;
T0 = 70;
V = (1/7.484)*500;
Tsp = 138;
UA = 16000;
Ta1 = 60;
kc = 8.5;
k = 16.96*10^12*exp(-32400/1.987/(T+460));
Fb0 = 1000;
Fm0 = 100;
mc0 = 1000;
ra = -k*Ca;
NCp = Ca*V*35+Cb*V*18+Cc*V*46+Cm*V*19.5;
ThetaCp = 35+Fb0/Fa0*18+Fm0/Fa0*19.5;
v0 = Fa0/0.923+Fb0/3.45+Fm0/1.54;
Ca0 = Fa0/v0;
Cb0 = Fb0/v0;
Cm0 = Fm0/v0;
tau = V/v0;
X = (Ca0-Ca)/Ca0;
mc =  mc0+kc*(T-Tsp)+kc/tau*I;
Ta2 =  T-(T-Ta1)*exp(-UA/(18*mc));
Q =  mc*18*(Ta2-Ta1);
% Differential equations
dCadt = 1/tau*(Ca0-Ca)+ra; 
dCbdt = 1/tau*(Cb0-Cb)+ra; 
dCcdt = 1/tau*(0-Cc)-ra; 
dCmdt = 1/tau*(Cm0-Cm); 
dTdt = (-Q-Fa0*ThetaCp*(T-T0)+(-36000)*ra*V)/NCp; 
dIdt = T-Tsp; 
dYfuncvecdt=[dCadt;dCbdt;dCcdt;dCmdt;dTdt;dIdt];


