#
# Utility to compute DQE from efficiencies
#
# M.Flynn 2013
#    Reformats *.det file and adds DQE
#    Note: many of the files in this directory
#          already have the DQE.
# ------------------------------------------

set file [tk_getOpenFile]

set fileIN [open $file r]
set fileOUT [open DQE.txt w]

# Echo first three lines
#-----------------------
puts $fileOUT [gets $fileIN]
puts $fileOUT [gets $fileIN]
gets $fileIN
puts $fileOUT "#energy(keV)  eta_signal  eta2_noise   DQE(E)"

# add dqe to the remaining lines
#-------------------------------
set line [gets $fileIN] ;# first line to process
while { [eof $fileIN] != 1} {
    set energy [lindex $line 0]
    set etaS [lindex $line 1]
    set etaN [lindex $line 2]
    set DQE [expr $etaS*$etaS/$etaN]
    puts $fileOUT [format "%7.1f %13.5f %11.5f %10.3f"  \
                  $energy $etaS $etaN $DQE]
    set line [gets $fileIN]
}
close $fileIN
close $fileOUT

exit


