#!/bin/sh
# The next line restarts using wish \
exec wish $0 ${1+"$@"}
#############################################################
#
#    XSPECT vers.3.5c
#
#	Model:  ______________
#	Author: ______________
#	Date:   ______________
#
#------------------------------------------------------------
#
#  Description ...
#  
#############################################################
#  The environmental variable XSPECT_DIR 
#  should be defined in the operating system for portability.
#
#  Alternatively, set it here:
#set env(XSPECT_DIR) "C:/XIRL/mikef/SRC/_Rad-Img"

#------------------------------------------------------------
# Configurations

set vers 3.5c

console show  ;# comment this line to hide the console
puts  "XSPECT vers. $vers \n"
set BIN [file join $env(XSPECT_DIR) _xspect3.5 _bin]

#------------------------------------------------------------
#  Configure for OS

if { "$tcl_platform(platform)" == "windows" } {

    set gnuplot [file join C:/ {Program Files (x86)} gnuplot bin wgnuplot.exe]

} else {

    puts "OS platform not supported: $tcl_platform(platform)"
}
#------------------------------------------------------------
# Define TCL directory and source required tcl procedures
set TCL [file join $env(XSPECT_DIR) _xspect3.5 _tcl]

#  or source all tcl procedures in $TCL using
set tspList [glob -directory $TCL *.tsp]
foreach tsp $tspList {
	source $tsp
}
#------------------------------------------------------------
# Simple graphic widget to quit the application.
# Applications will change this as required.

wm title . "XSPECT$vers"
frame  .commands
button .commands.quit  -text "quit" -command {destroy .}
pack   .commands.quit  -side left   -padx 20 -pady 10
pack   .commands       -side top

#############################################################
