function [ x y ] = FEM_Method( x, y, n, gamma, dgamma, ~, ~, m, dt)

H = zeros(2*n+2,2*n+2); Hl = zeros(4,4); f = zeros(2*n+2,1); 
fl = zeros(4,1); theta = zeros(n,1); l = zeros(n,1);
felec = zeros(4,1);

% the general equation for the force caused by the electric field at a point. 

V = 0.01;
lamda = 0.01;
d = 1;

%   Find Length and Angle of Each Element
for i = 1:n

    l(i) = sqrt(((x(i+1)-x(i))^2+(y(i+1)-y(i))^2));
    theta(i) = asin((y(i+1)-y(i))/l(i));
    
    if x(i+1) < x(i)
        theta(i)=pi-theta(i);
    end
 
    fx = (((l(i)*lamda*V)/d)/2)*cos(theta(i));
    fy = (((l(i)*lamda*V)/d)/2)*sin(theta(i));
    
    felec(:,i) = [fy; fx; fy; fx];
    
end

%   Calculate local H element matrices
for j=1:n;

    Hl(1,1)=l(j)/(6*m)*2*(sin(theta(j)))^2;
    Hl(1,2)=l(j)/(6*m)*-2*sin(theta(j))*cos(theta(j));
    Hl(1,3)=l(j)/(6*m)*(sin(theta(j)))^2;
    Hl(1,4)=l(j)/(6*m)*-sin(theta(j))*cos(theta(j));
    Hl(2,1)=l(j)/(6*m)*-2*sin(theta(j))*cos(theta(j));
    Hl(2,2)=l(j)/(6*m)*2*(cos(theta(j)))^2;
    Hl(2,3)=l(j)/(6*m)*-sin(theta(j))*cos(theta(j));
    Hl(2,4)=l(j)/(6*m)*(cos(theta(j)))^2;
    Hl(3,1)=l(j)/(6*m)*(sin(theta(j)))^2;
    Hl(3,2)=l(j)/(6*m)*-sin(theta(j))*cos(theta(j));
    Hl(3,3)=l(j)/(6*m)*2*(sin(theta(j)))^2;
    Hl(3,4)=l(j)/(6*m)*-2*sin(theta(j))*cos(theta(j));
    Hl(4,1)=l(j)/(6*m)*-sin(theta(j))*cos(theta(j));
    Hl(4,2)=l(j)/(6*m)*(cos(theta(j)))^2;
    Hl(4,3)=l(j)/(6*m)*-2*sin(theta(j))*cos(theta(j));
    Hl(4,4)=l(j)/(6*m)*2*(cos(theta(j)))^2;

%   Assemble Global H Matrix
    H(2*j-1:2*j+2,2*j-1:2*j+2) = H(2*j-1:2*j+2,2*j-1:2*j+2) + Hl;

%   Determine the Force Vector
    fl(1)=gamma*cos(theta(j))+dgamma*(-sin(theta(j)));
    fl(2)=gamma*sin(theta(j))+dgamma*(cos(theta(j)));
    fl(3)=gamma*-cos(theta(j))+dgamma*(sin(theta(j)));
    fl(4)=gamma*-sin(theta(j))+dgamma*(-cos(theta(j)));
    
    size(fl);
    size(felec(:,j));
    
%     fl = fl + felec(:,j);

%   Add Global Force Vector
    f(2*j-1:2*j+2)=f(2*j-1:2*j+2)+fl;
end

for m=1:(2*n+2);
    H(m,m)=0.000001+H(m,m);
end

%   Boundary conditions
% H(end-1,end-1) = (1+H(end-1,end-1))*1E10;  %fix last point in x direction
H(end,end) = (1+H(2*n+2,2*n+2))*1E10;      %fix last point in y direction
% H(1,1) = (1+H(1,1))*1E10;                  %fix first point in x direction
H(2,2) = (1+H(2,2))*1E10;                  %fix first point in y direction

%   Velocities
speedy = H\f;

%   Update position
for i=1:(n+1);
    
    x(i)=x(i)+speedy(2*i-1)*dt;
    y(i)=y(i)+speedy(2*i)*dt;   
    
end
end