%   Tracking Particle Deposition of Powder Coat on a Charged Surface

%   Code Written By: Mo Alkaysi, James Gorman, Bradley Keller
%   ME 574 Final Project

clc;
clear; 
close all; 

 
% Initial Conditions

C     = 0;      % particle center
I     = 2;      % particle Intensity
Xstep = 0.50;   % particle node spacing
FWHM  = 1;      % particle FWHM


gamma     = 0.1;      % set coeficient of isotropic surface energy
dgamma    =0.01;
g1        = 1;        % set coeficients of volume energy
g2        = 0.2;
m         = 1;        % set element mass
timesteps = 2000;     % set number of timesteps to calculate
dt        = 0.001;    % set timestep length

MinLength   = 0.2; 
MaxLength   = 0.8; 
CleanCycles = 2;   
InterpStyle = 2;   

     


Frames = Run_Simulation(C,I,Xstep,FWHM,gamma,dgamma,g1,g2,m,timesteps,dt,MinLength,MaxLength,CleanCycles,InterpStyle);

%%

movie2avi(Frames,'S1-2','fps',40,'quality',20)
