function Frames = Run_Simulation(C,I,Xstep,FWHM,gamma,dgamma,g1,g2,m,timesteps,dt,MinLength,MaxLength,CleanCycles,InterpStyle);

PlotVol    = 1;         
PlotArea   = 1; 

xmin = -4;               
xmax =  4;              
ymin = -2;              
ymax = 2;  

%create initial deposition profile
% 
% x = [-4 -3 -2 -1 0 1 2 3 4]
% y = [0 0.5 0.5 1 1 1 0.5 0.5 0]

% x = -4:0.1:4
% y = abs(sin(x))

% x = -4:0.1:4
% y = abs(cos(x))

x = [-4 -3 -2 -1 0 1 2 3 4]
y = [0 0.25 0.5 1 1.5 1 0.5 0.25 0]



%%%%%%%%  Begin Structural Evolution Loop  %%%%%%%%

for t = 1:timesteps;
         Frames(t) = plotting_function(x,y,xmin,xmax,ymin,ymax);
        n = length(x)-1;
        [ x, y] = FEM_Method(x,y,n,gamma,dgamma,g1,g2,m,dt);

        for i = 1:CleanCycles
            [x, y] = Delete_Nodes(x, y, MinLength, MaxLength, InterpStyle);

        end

        %calculate Surface areas and Volume
        if PlotVol == 1
        vol(t) = Volume(x,y);
        end
        if PlotArea == 1
        SArea(t) = Surface_Area(x,y);
        end
        if PlotVol == 1 || PlotArea == 1
        time(t) = t*dt;
        end
        
end 
Frames(t) = plotting_function(x,y,xmin,xmax,ymin,ymax);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Plot Volume vs Time
if PlotVol == 1
figure(2)
plot(time,vol);
xlabel('Elapsed Time');
ylabel('Film Volume');
saveas(figure(2), 'vol.jpg', 'jpg');
end

% Plot Surface Area vs Time
if PlotArea == 1
figure(3)
plot(time,SArea);
xlabel('Elapsed Time');
ylabel('Film Surface Area');
saveas(figure(3), 'SA.jpg','jpg');
end

end % end of simulation


